# 模拟

模拟可以让你快速测试代码，而不会改变真实农场的状态。
模拟的起始状态可以自由选择，当模拟结束时，真实农场将恢复到模拟开始前的确切状态。

使用 `simulate()` 函数来开始一次模拟。

指定执行的起始文件
`filename = "f1"`

以所有项目解锁并完全升级的状态开始
`sim_unlocks = Unlocks`

以 10000 根胡萝卜和 50 份干草开始
`sim_items = {Items.Carrot : 10000, Items.Hay : 50}`

以一个值为 13 的全局变量 "a" 开始
`sim_globals = {"a" : 13}`

使用固定的随机种子
`seed = 0`

将模拟加速至 64 倍
`speedup = 64`

运行模拟
`run_time = simulate(filename, sim_unlocks, sim_items, sim_globals, seed, speedup)`

`simulate()` 函数会返回模拟给定起始文件所花费的时间（以秒为单位）。

### 文件名
`simulate()` 函数的第一个参数是文件名，即显示在代码窗口顶部的名称。模拟将运行指定的文件，就像你点击了它的执行按钮一样。

### 起始解锁项
所有的编程功能，如循环、if 语句、列表、字典……将始终保持解锁状态。

第二个参数可用来指定模拟开始时，除了编程功能外，还应解锁/升级哪些内容。该参数必须是一个解锁项序列。模拟将以序列中所有解锁项都升级到最高等级的状态开始。

如果想指定非最高级的升级等级，可以传递一个将解锁项映射到解锁等级的字典。在这种情况下，负值对应于最高解锁等级。

### 起始物品
第三个参数可用来传递一个将物品映射到数量的字典，从而指定模拟开始时拥有的物品。

### 起始全局变量
由于模拟开始的是一次全新的程序执行，所以无法访问启动模拟的程序中的变量。
但是，第四个参数可以用来将值传递给模拟。这是一个将字符串形式的变量名映射到值的字典。这些变量随后会被添加到模拟内部执行的全局作用域中。

请注意，这会复制所有值，所以在模拟内部修改它们不会影响模拟外部的原始值。除了运行所需的时间外，无法从模拟中返回其他值。

### 随机种子
第五个参数可以用来指定模拟中使用的随机种子。这必须是一个正整数。负值将导致使用随机种子。

随机种子会影响到方方面面，从植物生长时间到迷宫布局再到水分蒸发时间，无所不包。如果使用相同的随机种子和相同的起始条件多次开始同一个模拟，结果应该始终是一样的。

### 加速
第六个参数是模拟的起始加速倍率，以便快速完成测试。如果游戏跟不上设定的速度，则会自动减速。

加速不会以任何方式影响模拟的结果。它的存在只是为了减少等待时间。